/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.textures;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.textures.ITextureAtlasSpriteLoader;

public final class ForgeTextureMetadata {
    public static final ForgeTextureMetadata EMPTY = new ForgeTextureMetadata(null);
    public static final IMetadataSectionSerializer<ForgeTextureMetadata> SERIALIZER = new Serializer();
    @Nullable
    private final ITextureAtlasSpriteLoader loader;

    public static ForgeTextureMetadata forResource(IResource resource) {
        ForgeTextureMetadata metadata = (ForgeTextureMetadata)resource.func_199028_a(SERIALIZER);
        return metadata == null ? EMPTY : metadata;
    }

    public ForgeTextureMetadata(@Nullable ITextureAtlasSpriteLoader loader) {
        this.loader = loader;
    }

    @Nullable
    public ITextureAtlasSpriteLoader getLoader() {
        return this.loader;
    }

    private static final class Serializer
    implements IMetadataSectionSerializer<ForgeTextureMetadata> {
        private Serializer() {
        }

        @Nonnull
        public String func_110483_a() {
            return "forge";
        }

        @Nonnull
        public ForgeTextureMetadata fromJson(JsonObject json) {
            ITextureAtlasSpriteLoader loader;
            if (json.has("loader")) {
                ResourceLocation loaderName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"loader"));
                loader = MinecraftForgeClient.getTextureAtlasSpriteLoader(loaderName);
                if (loader == null) {
                    throw new JsonSyntaxException("Unknown TextureAtlasSpriteLoader " + loaderName);
                }
            } else {
                loader = null;
            }
            return new ForgeTextureMetadata(loader);
        }
    }
}

